/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public class CatMateGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private static final double NEARBY_RADIUS_CHECK = 16.0;
    private final double moveSpeed;
    private final SimplyCatEntity cat;
    protected final Level level;
    private SimplyCatEntity target;
    private int mateDelay;
    private List<? extends SimplyCatEntity> nearbyCats;

    public CatMateGoal(SimplyCatEntity entityCat, double speed) {
        this.cat = entityCat;
        this.level = entityCat.m_9236_();
        this.moveSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cat.getSex() == Genetics.Sex.FEMALE) {
            return false;
        }
        this.nearbyCats = this.level.m_45976_(((Object)((Object)this.cat)).getClass(), this.cat.m_20191_().m_82400_(16.0));
        if (this.nearbyCats.size() >= (Integer)SCConfig.breeding_limit.get()) {
            return false;
        }
        LivingEntity catOwner = this.cat.m_269323_();
        if (this.ownerExceedsLimit(this.cat, catOwner) || this.ownerIsOffline(this.cat, catOwner) || this.cat.getMateTimer() > 0) {
            return false;
        }
        this.target = this.getNearbyMate();
        if (this.target != null && this.cat.m_21574_().m_148306_((Entity)this.target) && this.target.getBreedingStatus("inheat")) {
            if (!this.target.m_21824_()) {
                return true;
            }
            LivingEntity targetOwner = this.target.m_269323_();
            return !this.ownerExceedsLimit(this.target, targetOwner) && !this.ownerIsOffline(this.target, targetOwner);
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.cat.m_21827_() || this.target.m_21827_()) {
            return false;
        }
        boolean maleCooldownCheck = this.cat.getSex() == Genetics.Sex.MALE && this.cat.getMateTimer() == 0;
        boolean femaleHeatCheck = this.target.getSex() == Genetics.Sex.FEMALE && this.target.getBreedingStatus("inheat");
        this.nearbyCats = this.level.m_45976_(((Object)((Object)this.cat)).getClass(), this.cat.m_20191_().m_82400_(16.0));
        return maleCooldownCheck && this.target.m_6084_() && femaleHeatCheck && this.mateDelay < 60 && this.nearbyCats.size() < (Integer)SCConfig.breeding_limit.get() && this.cat.m_21574_().m_148306_((Entity)this.target);
    }

    private boolean ownerExceedsLimit(SimplyCatEntity tamedCat, LivingEntity owner) {
        return tamedCat != null && tamedCat.m_21824_() && (Integer)SCConfig.tamed_limit.get() != 0 && owner != null && owner.getPersistentData().m_128451_("CatCount") >= (Integer)SCConfig.tamed_limit.get();
    }

    private boolean ownerIsOffline(SimplyCatEntity tamedCat, LivingEntity owner) {
        return tamedCat != null && tamedCat.m_21824_() && owner == null;
    }

    public void m_8041_() {
        this.target = null;
        this.mateDelay = 0;
        this.nearbyCats.clear();
    }

    public void m_8037_() {
        this.cat.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.cat.m_8132_());
        this.target.m_21563_().m_24960_((Entity)this.cat, 10.0f, (float)this.target.m_8132_());
        this.cat.m_21573_().m_5624_((Entity)this.target, this.moveSpeed);
        this.target.m_21573_().m_5624_((Entity)this.cat, this.moveSpeed);
        ++this.mateDelay;
        if (this.mateDelay >= 60 && this.cat.m_20280_((Entity)this.target) < 4.0) {
            if (this.level.f_46441_.m_188503_(4) <= 2) {
                this.startPregnancy();
            }
            this.cat.setMateTimer((Integer)SCConfig.male_cooldown.get());
        }
    }

    private SimplyCatEntity getNearbyMate() {
        List list = this.level.m_45971_(((Object)((Object)this.cat)).getClass(), PARTNER_TARGETING, (LivingEntity)this.cat, this.cat.m_20191_().m_82400_(16.0));
        double d0 = Double.MAX_VALUE;
        SimplyCatEntity entityCat = null;
        if (this.cat.getSex() == Genetics.Sex.MALE) {
            for (SimplyCatEntity cat1 : list) {
                if (!this.cat.m_7848_((Animal)cat1) || !(this.cat.m_20280_((Entity)cat1) < d0)) continue;
                entityCat = cat1;
                d0 = this.cat.m_20280_((Entity)cat1);
            }
        }
        return entityCat;
    }

    private void startPregnancy() {
        int litterSize = this.target.getKittens() <= 0 ? this.level.f_46441_.m_188503_(6) + 1 : this.level.f_46441_.m_188503_(6 - this.target.getKittens()) + 1;
        this.target.setBreedingStatus("ispregnant", true);
        this.target.setKittens(litterSize);
        this.target.addFather(this.cat, this.target.getKittens());
        if (litterSize == 6 || this.target.getKittens() == 6 || this.level.f_46441_.m_188503_(4) == 0) {
            this.target.setBreedingStatus("inheat", false);
            this.target.setTimeCycle("pregnancy", (Integer)SCConfig.pregnancy_timer.get());
        }
    }
}

